/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.IntegerOrReferencePanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.CounterParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CounterTwoLimesPanel
extends AbstractProtectionPanel {
    protected IntegerOrReferencePanel fOn;
    protected IntegerOrReferencePanel fOff;
    private JLabel fStartValueLabel;
    private EditableNumericSpinner fStartValue;
    protected WiringDiagram fWiringDiagram;

    public CounterTwoLimesPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.fWiringDiagram = ((BlockParameter)parameterReference).getBlock().getWiringDiagram();
        this.initialize((CounterParameter)parameterReference);
    }

    private void initialize(CounterParameter parameterReference) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        this.addParameterPane(panel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        this.fOn = new IntegerOrReferencePanel();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        panel.add((Component)this.fOn, gbc);
        this.fOff = new IntegerOrReferencePanel();
        gbc.insets = new Insets(6, 0, 0, 6);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        panel.add((Component)this.fOff, gbc);
        this.fStartValueLabel = new JLabel();
        this.fStartValueLabel.setAlignmentY(0.0f);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(6, 4, 6, 0);
        gbc.gridwidth = 1;
        panel.add((Component)this.fStartValueLabel, gbc);
        this.fStartValue = new EditableNumericSpinner();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(6, 4, 6, 0);
        gbc.gridwidth = 1;
        panel.add((Component)this.fStartValue, gbc);
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        panel.add((Component)new JPanel(), gbc);
        if (!parameterReference.getBlock().getWiringDiagram().getHardware().supports("counter_startValue")) {
            this.fStartValueLabel.setVisible(false);
            this.fStartValue.setVisible(false);
        }
    }

    public boolean checkChanged() {
        return super.checkChanged() || this.fOn.checkChanged() || this.fOff.checkChanged() || this.fStartValue.checkChanged();
    }

    public boolean checkFieldContents() {
        if (!this.fOn.checkValue(true)) {
            this.fOn.requestFocus();
            return false;
        }
        if (!this.fOff.checkValue(true)) {
            this.fOff.requestFocus();
            return false;
        }
        if (!this.fStartValue.checkValue(true)) {
            this.fStartValue.requestFocus();
            return false;
        }
        return super.checkFieldContents();
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        Block notIncluded = ((BlockParameter)this.fParameterReference).getBlock();
        this.fOn.setReferenceList(this.fWiringDiagram.getBlocksForReference(notIncluded, true));
        this.fOff.setReferenceList(this.fWiringDiagram.getBlocksForReference(notIncluded, true));
        this.fOn.setProperties(((CounterParameter)this.fParameterReference).getOn());
        this.fOff.setProperties(((CounterParameter)this.fParameterReference).getOff());
        this.fStartValue.setProperties(((CounterParameter)this.fParameterReference).getStartValue());
    }

    public void setLabels() {
        super.setLabels();
        this.fOn.setTitle(Language.getString("dialog.parameter.counter.onLimes", "On"));
        this.fOff.setTitle(Language.getString("dialog.parameter.counter.offLimes", "Off"));
        this.fStartValueLabel.setText(Language.getString("dialog.parameter.counter.startValue", "start value") + ": ");
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        ((CounterParameter)this.fParameterReference).setOn(this.fOn.getValue());
        ((CounterParameter)this.fParameterReference).setOff(this.fOff.getValue());
        ((CounterParameter)this.fParameterReference).setStartValue(this.fStartValue.getValueProperties());
    }
}

